// ==UserScript==
// @name         5ch オリジナルポップアップ （本文内 ﾜｯﾁｮｲ 用）
// @namespace    http://tampermonkey.net/
// @version      1.2
// @description  本文内のワッチョイっぽいxxxx-xxxxをポップアップリンク化
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// @run-at       document-end
// ==/UserScript==
(function() {
    'use strict';

    const style = document.createElement('style');
    style.textContent = `
          .post-trip {
                color: #aabbcc;
                cursor: pointer;
          }
    `;
    document.head.appendChild(style);

    const tripRegex = /([A-Za-z0-9+/]{4})-([A-Za-z0-9+/]{4})/g;
    const excludeTags = ['A', 'SPAN'];

    // テキストノードを再帰的に取得しつつ、除外タグ内はスキップ
    function getTextNodes(root) {
        const walker = document.createTreeWalker(root, NodeFilter.SHOW_TEXT, null, false);
        const nodes = [];
        while (walker.nextNode()) {
            const parentTag = walker.currentNode.parentNode.nodeName;
            if (!excludeTags.includes(parentTag)) {
                nodes.push(walker.currentNode);
            }
        }
        return nodes;
    }

    function wrapTripSpans(element) {
        const nodes = getTextNodes(element);
        nodes.forEach(node => {
            const text = node.nodeValue;
            let replaced = false;
            const frag = document.createDocumentFragment();
            let lastIndex = 0;
            tripRegex.lastIndex = 0;
            let match;

            while ((match = tripRegex.exec(text)) !== null) {
                const idx = match.index;

                // マッチ前の部分を追加
                if (idx > lastIndex) {
                    frag.appendChild(document.createTextNode(text.substring(lastIndex, idx)));
                }

                // マッチした4文字-4文字
                const tripText = match[1] + '-' + match[2];

                const span = document.createElement('span');
                span.className = 'post-trip';
                span.setAttribute('data-trip', tripText);
                span.textContent = tripText;

                frag.appendChild(span);

                lastIndex = tripRegex.lastIndex;
                replaced = true;
            }

            // 残りのテキストを追加
            if (lastIndex < text.length) {
                frag.appendChild(document.createTextNode(text.substring(lastIndex)));
            }

            // spanへの置き換え
            if (replaced) {
                node.parentNode.replaceChild(frag, node);
            }
        });
    }

    function processAll() {
        document.querySelectorAll('.post-content').forEach(el => {
            // 重複処理防止フラグがあればスキップ
            if (!el.dataset.tripProcessed) {
                wrapTripSpans(el);
                el.dataset.tripProcessed = 'true';
            }
        });
    }

    processAll();

    const observer = new MutationObserver(mutations => {
        mutations.forEach(mutation => {
            mutation.addedNodes.forEach(node => {
                if (node.nodeType === 1) {
                    // 追加された要素に span.post-trip があればチェック
                    const tripSpans = node.matches && node.matches('.post-trip') ? [node] : Array.from(node.querySelectorAll('.post-trip'));
                    tripSpans.forEach(span => {
                        const text = span.textContent;
                        if (text.startsWith('>')) {
                            span.textContent = text.substring(1); // 先頭の '>' を削除
                        }
                    });

                    // さらにpost-contentが追加されたらwrapTripSpansを再実行（必要に応じて）
                    if (node.classList && node.classList.contains('post-content') && !node.dataset.tripProcessed) {
                        wrapTripSpans(node);
                        node.dataset.tripProcessed = 'true';
                    }
                }
            });
        });
    });

    observer.observe(document.body, {childList: true, subtree: true});

    // ここからクリックイベント追加 ---------------------
    // まず既存のイベントを解除（namespace付きなので安心）
    $(document).off('click.debugPostTrip', 'span.post-trip');

    // 新たにイベント登録
    $(document).on('click.debugPostTrip', 'span.post-trip', function () {
        console.log('post-trip clicked:', $(this).text());
        const tripcode = $(this).data('trip');
        console.log('tripcode from data-trip:', tripcode);
        if (!tripcode) return;

        if (!window.popupStack) window.popupStack = [];

        // 重複ポップアップを削除
        for (let i = window.popupStack.length - 1; i >= 0; i--) {
            const p = window.popupStack[i];
            if (p.trigger && p.trigger.text().includes(tripcode)) {
                console.log('Removing existing popup triggered by:', p.trigger.text());
                p.popup.remove();
                window.popupStack.splice(i, 1);
            }
        }

        if (typeof window.createPopupFromTrip !== 'function') {
            console.warn('createPopupFromTrip function not found.');
            return;
        }
        window.createPopupFromTrip($(this), tripcode);
        console.log('createPopupFromTrip called with tripcode:', tripcode);
    });
    // ここまでクリックイベント追加 ---------------------

})();
